#!/usr/bin/lua
function main()

    local ruleID=m.getvar("RULE.id")
    if ruleID == nil then
        return nil
    end
    local rule_msg=m.getvar("RULE.msg")
    if rule_msg == nil then
        return nil
    end
    local remote_addr = m.getvar("REMOTE_ADDR");
    if remote_addr == nil then
        return nil
    end
    local script_filename = m.getvar("SCRIPT_FILENAME");

    if ruleID == "400003" then
        rule_msg= rule_msg .. " PE:" .. m.getvar("REQBODY_PROCESSOR_ERROR")
        rule_msg= rule_msg .. " BQ:" .. m.getvar("MULTIPART_BOUNDARY_QUOTED")
        rule_msg= rule_msg .. " BW:" .. m.getvar("MULTIPART_BOUNDARY_WHITESPACE")
        rule_msg= rule_msg .. " DB:" .. m.getvar("MULTIPART_DATA_BEFORE")
        rule_msg= rule_msg .. " DA:" .. m.getvar("MULTIPART_DATA_AFTER")
        rule_msg= rule_msg .. " HF:" .. m.getvar("MULTIPART_HEADER_FOLDING")
        rule_msg= rule_msg .. " LF:" .. m.getvar("MULTIPART_LF_LINE")
        rule_msg= rule_msg .. " SM:" .. m.getvar("MULTIPART_MISSING_SEMICOLON")
        rule_msg= rule_msg .. " IQ:" .. m.getvar("MULTIPART_INVALID_QUOTING")
        rule_msg= rule_msg .. " IF:" .. m.getvar("MULTIPART_INVALID_HEADER_FOLDING")
        rule_msg= rule_msg .. " FE:" .. m.getvar("MULTIPART_FILE_LIMIT_EXCEEDED")
    end

    local fh = assert(io.open('/usr/share/ilabs_antimalware/logs/instantprotection.log','a'))
    fh:write(string.format("[%s] [%s] [%s] [%s] [%s]\n",os.date("%Y-%m-%d %H:%M:%S"),remote_addr,script_filename,rule_msg,ruleID))
    fh:close()

    return 1

end