#!/bin/bash

# Determinar version de easyapache
if [ -e /etc/cpanel/ea4/is_ea4 ]; then
  EASYAPACHE=4
  POSTVIRTUALHDIR="/etc/apache2/conf.d/includes/"
else
  EASYAPACHE=3
  POSTVIRTUALHDIR="/usr/local/apache/conf/includes/"
fi

if grep -E -i '^include.+?pyxsoft-check\.conf' $POSTVIRTUALHDIR/post_virtualhost_global.conf >/dev/null; then
    # "Pyxsoft Virtual Host already exists"
    :
else
    echo "# Included by Pyxsoft Anti Malware -- Do not delete" > /tmp/newfile.txt
    echo "Include $POSTVIRTUALHDIR/pyxsoft-check.conf" >> /tmp/newfile.txt
    echo  >>/tmp/newfile.txt
    touch $POSTVIRTUALHDIR/post_virtualhost_global.conf
    cat $POSTVIRTUALHDIR/post_virtualhost_global.conf >> /tmp/newfile.txt
    mv $POSTVIRTUALHDIR/post_virtualhost_global.conf $POSTVIRTUALHDIR/post_virtualhost_global.conf.bak -f
    mv /tmp/newfile.txt $POSTVIRTUALHDIR/post_virtualhost_global.conf -f
    chmod 0600 $POSTVIRTUALHDIR/pyxsoft-check.conf
    chmod 0644 $POSTVIRTUALHDIR/post_virtualhost_global.conf
fi

# Fix listening port
# port=$(grep '^Listen 0\.0\.0\.0' /usr/local/apache/conf/httpd.conf --max-count=1 | cut -d: -f2)
port=$(grep 'apache_port' /var/cpanel/cpanel.config |  cut -d: -f2)
if  [ "$port" = "" ]; then
        port=80
fi
sed  -i "s#^<VirtualHost.*#<VirtualHost 127.0.0.1:$port>#" $POSTVIRTUALHDIR/pyxsoft-check.conf
echo "$port" > /usr/share/ilabs_antimalware/data/apache_port
