# 
# This script uninstalls the Anti Malware Plugin for WHM
#
FOLDER=/usr/share/ilabs_antimalware

OS=$(grep -E -o '[0-9]' /etc/redhat-release | head -n1);

if [ -e /etc/cpanel/ea4/is_ea4 ]; then
    EASYAPACHE=4
    POSTVIRTUALHDIR="/etc/apache2/conf.d/includes"
    MODSECCONFDIR="/etc/apache2/conf.d/modsec"
else
    EASYAPACHE=3
    POSTVIRTUALHDIR="/usr/local/apache/conf/includes"
    MODSECCONFDIR="/usr/local/apache/conf"
fi

if [ $OS -le 6 ]; then
	echo "CentOS $OS uninstallation script";
elif [ $OS -eq 7 ]; then
	echo "CentOS 7 uninstallation script";
fi

echo -n "Uninstall Anti Malware Plugin? (y/n) "
read RES
if [ "$RES" = "y" ]; then

	# Eliminar integracion con WHM
	\rm -f  /usr/local/cpanel/whostmgr/docroot/cgi/addon_antimalware.php
	\rm -f /usr/local/cpanel/whostmgr/docroot/cgi/ilabs_antimalware
        echo "WHM User Interface removed"

	# Eliminar archivo de aviso a usuarios
	\rm -f /usr/local/cpanel/cgi-sys/amplugin.shtml
        
	# Eliminar inspeccion en mod_security
	\rm -f ${MODSECCONFDIR}/modsec2.antimalware.conf
	sed -i "s%^Include $MODSECCONFDIR/modsec2.antimalware.conf%#%" ${MODSECCONFDIR}/modsec2.user.conf
        echo "HTTP Inspector removed"

	# Eliminar FTP inspector
	sh uninstall_ftp_inspector.sh
        echo "FTP Inspector removed"

	# Eliminar Cron
	\rm -f /etc/cron.d/pyx_antimalware
	\rm -f /etc/cron.d/pyx_cronjobs
        echo "Cron tasks removed"

	# Eliminar folder
	cd ~
	rm -fR /usr/share/ilabs_antimalware
        echo "Program removed"

        # Eliminar portfix del archivo de inicio de apache
        if [ $OS -le 6 ]; then
           sed -i "s#/usr/share/ilabs_antimalware/commands/portfix.sh##" /etc/init.d/httpd
        elif [ $OS -eq 7 ]; then
            :
        fi
        echo "Portfix removed"
        
	
	# Restart Apache
	echo "Restarting apache..."
	service httpd restart 2>&1

	# Done!!
	echo "Anti Malware Plugin uninstalled."

fi


