FOLDER=/usr/share/ilabs_antimalware
OK=1
CMD="-i"
OS=$(grep -E -o '[0-9]' /etc/redhat-release | head -n1);
MIN_WHM='11.56' # Incluye soporte para ioncube loader 5 en internal php 11.56
WHM_VERSION=$(cat /usr/local/cpanel/version)
CLOUDLINUX_VERSION=$(grep -P -o  "\d\.\d" /etc/cloudlinux-release 2>/dev/null)
IONCUBE_MIN='5.0.0'
IONCUBE_INSTALLED=$(/usr/local/cpanel/3rdparty/bin/php -v | grep 'ioncube' -i | grep -P  -o 'v\d*\.\d*\.\d*' | cut -c 2-)

if [ $OS -le 6 ]; then
	echo "CentOS $OS installation script";
elif [ $OS -eq 7 ]; then
	echo "CentOS 7 installation script";
fi


if [ -e /etc/cpanel/ea4/is_ea4 ]; then
    EASYAPACHE=4
    POSTVIRTUALHDIR="/etc/apache2/conf.d/includes"
    MODSECCONFDIR="/etc/apache2/conf.d/modsec"
else
    EASYAPACHE=3
    POSTVIRTUALHDIR="/usr/local/apache/conf/includes"
    MODSECCONFDIR="/usr/local/apache/conf"
fi
echo "EasyApache $EASYAPACHE detected";
echo "cPanel version $WHM_VERSION installed"
echo "Internal ionCube loader version installed: $IONCUBE_INSTALLED"


exec 2>&1

if [ ! -z "$@" ]; then
        CMD="$@"
fi

# Funcion para comparar versiones
# Devuelve en $? :
# 0: version1 = version2
# 1: version1 > version2
# 2: version1 < version2
vercomp () {
    if [[ $1 == $2 ]]
    then
        return 0
    fi
    local IFS=.
    local i ver1=($1) ver2=($2)
    # fill empty fields in ver1 with zeros
    for ((i=${#ver1[@]}; i<${#ver2[@]}; i++))
    do
      	ver1[i]=0
    done
    for ((i=0; i<${#ver1[@]}; i++))
    do
      	if [[ -z ${ver2[i]} ]]
        then
            # fill empty fields in ver2 with zeros
            ver2[i]=0
        fi
	if ((10#${ver1[i]} > 10#${ver2[i]}))
        then
            return 1
        fi
	if ((10#${ver1[i]} < 10#${ver2[i]}))
        then
            return 2
        fi
    done
    return 0
}


compileCommands() {
	# Compilar comandos
	make --directory="${FOLDER}/c-elements" install

	if [[ $? -ne 0 ]]; then
        echo "Error compiling Pyxsoft Elements"
        exit 1;
    fi


    # Eliminar codigo fuente
    rm -fR "${FOLDER}/c-elements"
}

vercomp $CLOUDLINUX_VERSION 7.2
if [ $? -eq 1 ] && [ -e /etc/cloudlinux-release ]; then
    echo "Applying CloudLinux 7.3 fix"
    # Soluciona problema de proteccion de symlinks que impide ejecutar php interno desde apache
    chown -h bin:bin /usr/local/cpanel/3rdparty/bin/php
fi


#  vercomp $WHM_VERSION $MIN_WHM
#        if [ $? -eq 2 ]; then
#            # La version de cpanel es menor que la minima
#            echo "Minimal required cPanel version is $MIN_WHM"
#            echo "Please upgrade your cPanel in order to install Pyxsoft Anti Malware"
#            exit 1
#        fi
#
#  vercomp $IONCUBE_INSTALLED $IONCUBE_MIN
#        if [ $? -eq 2 ]; then
#            # La version de cpanel es menor que la minima
#            echo "Minimal required internal ioncube version is $IONCUBE_MIN"
#            echo "This system has an outdated version."
#            echo "Please upgrade your cPanel in order to install Pyxsoft Anti Malware"
#            echo "See more details about this issue in:"
#            echo "http://www.pyxsoft.com/customers/knowledgebase.php?action=displayarticle&id=5"
#            exit 1
#        fi


function upgrade_script(){
	echo "Upgrading script..."
	# Comprobar que estamos en la carpeta correcta
	if [ ! -e modsec_scan.php ]; then
		echo "Wrong folder. Aborting Upgrade."
		exit 1
	fi

	if [ ! -d $FOLDER ]; then
		mkdir $FOLDER
	fi

	# Copiar todos los archivos a la carpeta de destino
	# No copiar el archivo license.txt
	rm -f license.txt 
	rm -f license2.txt 
	cp * $FOLDER -fR

	# Mover el acceso en WHM
	# mv -f $FOLDER/addon_antimalware.php  /usr/local/cpanel/whostmgr/docroot/cgi/
	# chmod 0755 /usr/local/cpanel/whostmgr/docroot/cgi/addon_antimalware.php

	# Registrar la aplicacion en WHM si no ha sido registrada
	/usr/local/cpanel/bin/register_appconfig /usr/share/ilabs_antimalware/includes/pyxsoft_antimalware.conf
	if [ ! -f "/var/cpanel/apps/pyxsoft_antimalware.conf" ]; then
		if [ -f "/usr/local/cpanel/bin/register_appconfig" ]; then
		/usr/local/cpanel/bin/register_appconfig /usr/share/ilabs_antimalware/includes/pyxsoft_antimalware.conf
		fi
	fi

    compileCommands

	# Establecer permisos para archivos que utilizara mod security
	chmod 0755 $FOLDER/modsec_name_scan.php
	chmod 0755 $FOLDER/modsec_scan.php
	touch $FOLDER/filescan.log
	chmod 0666 $FOLDER/filescan.log
	touch $FOLDER/license.txt
	chmod 0666 $FOLDER/license.txt
	touch $FOLDER/license2.txt
	chmod 0666 $FOLDER/license2.txt
	touch $FOLDER/firewall/ipdeny.txt
	chmod 0666 $FOLDER/firewall/ipdeny.txt
	touch $FOLDER/logs/firewall.log
	chmod 0666 $FOLDER/logs/firewall.log
	touch $FOLDER/firewall/f.dat
	chmod 0666 $FOLDER/firewall/f.dat
    touch $FOLDER/data/enc_pas.dat
    chmod 0666 $FOLDER/data/enc_pas.dat
	
	# -> Escritura de version de modsecurity
	touch $FOLDER/logs/modsecversion.txt
	chmod 0666 $FOLDER/logs/modsecversion.txt

	# -> Chequeo de editor de texto de aplicaciones
	chmod 0755 $FOLDER/adicionales/checkApp.php
	touch $FOLDER/logs/checkApp.log
	chmod 0666 $FOLDER/logs/checkApp.log

	# -> Verificar estado de proteccion http
	touch $FOLDER/logs/ok.txt
	chmod 0666 $FOLDER/logs/ok.txt
	
	# -> Analizar ataques de fuerza bruta
	chmod 0755 $FOLDER/adicionales/pyx_bf.php
	touch $FOLDER/logs/loginfailed.log
	chmod 0666 $FOLDER/logs/loginfailed.log
	touch $FOLDER/data/bruteforce.dat
	chmod 0666 $FOLDER/data/bruteforce.dat
	touch $FOLDER/data/badips.dat
	chmod 0666 $FOLDER/data/badips.dat
	chmod 0755 $FOLDER/adicionales/bf_test.php

    # -> Proteccion contra exploits
	chmod 0755 $FOLDER/adicionales/jce.php

    # -> Registro de correos enviados
    chmod 0755 $FOLDER/pyx_sendmail.php
    touch $FOLDER/logs/mail.log
    chmod 0666 $FOLDER/logs/mail.log
	touch $FOLDER/data/mailers.dat
	chmod 0666 $FOLDER/data/mailers.dat

    # -> Registro general
    touch $FOLDER/logs/pyxsoft.log
    chmod 0666 $FOLDER/logs/pyxsoft.log

    # -> Regidtro de proteccion instantanea
    touch $FOLDER/logs/instantprotection.log
    chmod 0666 $FOLDER/logs/instantprotection.log

	# Establecer permisos de ejecucion a comandos
	chmod 0755 $FOLDER/commands/* 
	chmod 0755 $FOLDER/pyxsoft-antimalware.pl
        chmod 0755 $FOLDER/sendinfo.php
        chmod 0744 $FOLDER/sendfile.php

        # Crear comandos
        if [ ! -f /usr/bin/send2pyxsoft ]; then
            ln -s /usr/share/ilabs_antimalware/sendfile.php /usr/bin/send2pyxsoft
        fi

	# Actualizar servicio pyxsoft-antimalware
	# \cp -f /usr/share/ilabs_antimalware/system_files/pyxsoft-antimalware /etc/init.d/pyxsoft-antimalware
	# chmod 0755 /etc/init.d/pyxsoft-antimalware
	# chown root:root /etc/init.d/pyxsoft-antimalware


	# Actualizar archivo de aviso a usuarios segun versino de apache
        apacheVersion=$(httpd -v | grep  'Apache/[\d\.]*' --color --max-count=1 -P -o | cut -d/ -f2)
        vercomp $apacheVersion 2.4.0
        if [ $? -eq 2 ]; then
            # La version de apache es menor a 2.4.0
            echo "Apache version: $apacheVersion (< 2.4.0)"
            mv $FOLDER/amplugin.shtml /usr/local/cpanel/cgi-sys/amplugin.shtml -f
            mv $FOLDER/denied.shtml /usr/local/cpanel/cgi-sys/denied.shtml -f
            mv $FOLDER/bfdenied.shtml /usr/local/cpanel/cgi-sys/bfdenied.shtml -f
        else
            # La version de apache es mayor o igual a 2.4.0
            echo "Apache version: $apacheVersion (>= 2.4.0)"
            mv $FOLDER/amplugin0204.shtml /usr/local/cpanel/cgi-sys/amplugin.shtml -f
            mv $FOLDER/denied0204.shtml /usr/local/cpanel/cgi-sys/denied.shtml -f
            mv $FOLDER/bfdenied0204.shtml /usr/local/cpanel/cgi-sys/bfdenied.shtml -f

        fi

    # BF Unlock
    mv $FOLDER/cgi-sys/pyx-bf_unlock.php /usr/local/cpanel/cgi-sys/pyx-bf_unlock -f
    mv $FOLDER/cgi-sys/tahomabd.ttf /usr/local/cpanel/cgi-sys/tahomabd.ttf -f

    # Upload blocked message
	chmod 0644 /usr/local/cpanel/cgi-sys/amplugin.shtml
	chown root:wheel /usr/local/cpanel/cgi-sys/amplugin.shtml

    # Access denied message
	chmod 0644 /usr/local/cpanel/cgi-sys/denied.shtml
	chown root:wheel /usr/local/cpanel/cgi-sys/denied.shtml

    # BF Deny
	chmod 0644 /usr/local/cpanel/cgi-sys/bfdenied.shtml
	chown root:wheel /usr/local/cpanel/cgi-sys/bfdenied.shtml

	# BF Unlock
	chmod 0755 /usr/local/cpanel/cgi-sys/pyx-bf_unlock
	chown root:wheel /usr/local/cpanel/cgi-sys/pyx-bf_unlock
	chmod 0644 /usr/local/cpanel/cgi-sys/tahomabd.ttf
	chown root:wheel /usr/local/cpanel/cgi-sys/tahomabd.ttf


	# Agregar virtual host para chequeo de configuracion
	\cp -f $FOLDER/pyxsoft-check.conf  $POSTVIRTUALHDIR/pyxsoft-check.conf
        
        # Agregar el portfix a archivo de inicio de apache
        reiniciar_apache=false

        if [ $OS -le 6 ]; then
            if grep -E -i '^/usr/share/ilabs_antimalware/commands/portfix.sh' /etc/init.d/httpd >/dev/null; then
                echo "Apache port autodetection already installed"
            else
                sed -i "s#^ *case \$ARGV#/usr/share/ilabs_antimalware/commands/portfix.sh\ncase \$ARGV#" /etc/init.d/httpd
                echo "Portfix installed in httpd.ini"
                reiniciar_apache=true
            fi
        elif [ $OS -eq 7 ]; then
            :
        fi

	# Revisar si pyxsoft-check.conf está incluido en httpd.conf 
	if grep -E -i '^include.+?pyxsoft-check\.conf' $POSTVIRTUALHDIR/post_virtualhost_global.conf >/dev/null; then
        echo "Pyxsoft Virtual Host already exists"
	else
		echo "# Included by Pyxsoft Anti Malware -- Do not delete" > newfile.txt
		echo "Include $POSTVIRTUALHDIR/pyxsoft-check.conf" >> newfile.txt
		echo  >>newfile.txt
		cat $POSTVIRTUALHDIR/post_virtualhost_global.conf >> newfile.txt
		mv $POSTVIRTUALHDIR/post_virtualhost_global.conf $POSTVIRTUALHDIR/post_virtualhost_global.conf.bak -f
		mv newfile.txt $POSTVIRTUALHDIR/post_virtualhost_global.conf -f
		chmod 0600 $POSTVIRTUALHDIR/pyxsoft-check.conf
		chmod 0644 $POSTVIRTUALHDIR/post_virtualhost_global.conf
                reiniciar_apache=true

		echo "Pyxsoft Virtual Host installed"
	fi

        # Reiniciar Apache
        if [ "$reiniciar_apache" = true ] ; then
            echo "Restarting apache..."
            if [ $OS -le 6 ]; then
                /etc/init.d/httpd restart 2>&1
            elif [ $OS -eq 7 ]; then
                systemctl restart httpd 2>&1
            fi
        fi

	# Agregar inspeccion en mod_security
	echo "Determining the Mod Security installed version..."
	echo -n "0" > /usr/share/ilabs_antimalware/logs/modsecversion.txt
	wget local.pyxsoft.com?getMS_version -O /dev/null  -q
	version=$(</usr/share/ilabs_antimalware/logs/modsecversion.txt)

	if [ $version -eq 0 ]; then
		echo "Mod security version could not be detected."
		echo "It is normal, I will detect the version when you visit the plugin in WHM."
		\cp -f $FOLDER/modsec2.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf
	elif [ "$version" -ge "02090000" ]; then
		echo "Mod security version OK ($version)"
		echo "cp -f $FOLDER/modsec0290.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf"
		\cp -f $FOLDER/modsec0290.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf

	elif [ "$version" -ge "02070000" ]; then
		echo "Old mod security version: $version. Consider upgrading to 2.9 or superior"
		\cp -f $FOLDER/modsec0270.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf

	elif [ "$version" -ge "02060000" ]; then
                echo "You have Mod Security $version. Some features will not work here"
		echo "If possible, upgrade your mod security installation to version 2.9 or superior"
		\cp -f $FOLDER/modsec0260.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf

	else
		echo "You have a very old mod security version. Some pyxsoft features will not work here."
		\cp -f $FOLDER/modsec2.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf
	fi

	chmod 0600 $MODSECCONFDIR/modsec2.antimalware.conf 
	
	# Eliminar archivos innecesarios de la carpeta del usuario
	rm -f $FOLDER/install.sh
	
        # Eliminar las firmas de versiones anteriores. Se puede eliminar esta seccion mas adelante.
        if [ -e /usr/share/ilabs_antimalware/sigs/am.ndb ]; then
            rm -f /usr/share/ilabs_antimalware/sigs/am.ndb
            rm -f /usr/share/ilabs_antimalware/sigs/am.hdb
            rm -f /usr/share/ilabs_antimalware/sigs/am1.ndb
            rm -f /usr/share/ilabs_antimalware/sigs/am1.hdb
        fi

	# Descargar las firmas para usar por primera vez (se puede eliminar esta seccion mas adelante)
        echo "Downloading signatures (1/3)..."
	wget http://labs.pyxsoft.com/sigs/pyx_ask.ndb -q -O /usr/share/ilabs_antimalware/sigs/pyx_ask.ndb
        echo "Downloading signatures (2/3)..."
	wget http://labs.pyxsoft.com/sigs/pyx.ndb -q -O /usr/share/ilabs_antimalware/sigs/pyx.ndb
        echo "Downloading signatures (3/3)..."
	wget http://labs.pyxsoft.com/sigs/pyx.hdb -q -O /usr/share/ilabs_antimalware/sigs/pyx.hdb
	
	# Instalar FTP inspector
        if [ $OS -le 6 ]; then
            chmod 755 $FOLDER/pure-ftpd-inspector.php
            if grep 'pure-ftpd-inspector' /etc/init.d/pure-ftpd >/dev/null; then
            echo "FTP Inspector already installed"
            else
                    echo "Installing FTP Inspector in CentOS $OS..."
                    # La salida hacia dev null impide que PHP se quede pegado
                    sh $FOLDER/includes/install_ftp_inspector.sh >/dev/null
            fi
        elif [ $OS -eq 7 ]; then
                echo "We are working to make FTP inspector compatible in CentOS 7.";
        fi
	
	# Instalar cron
	echo "4 2 * * * root /usr/local/cpanel/3rdparty/bin/php $FOLDER/cron/daily.php" > /etc/cron.d/pyx_antimalware
	echo "*/10 * * * * root /usr/local/cpanel/3rdparty/bin/php $FOLDER/cron/cronjobs.php" > /etc/cron.d/pyx_cronjobs
	
	# Reparar la configuracion de modse2.conf y httpd.conf
	# que eventualmente puede estar bloqueando la ejecucion de reglas
	# desde 127.0.0.1
	# /usr/local/cpanel/3rdparty/bin/php -q /usr/share/ilabs_antimalware/includes/modsec_fix.php
	# No es necesario desde el uso de virtualhost
	
        # Instalar mail watcher para php - en futuras versiones
        # sed -i 's#^sendmail_path.*#sendmail_path= "/usr/share/ilabs_antimalware/pyx_sendmail.php"#' /usr/local/lib/php.ini

	# Reiniciar apache debido a las nuevas reglas en mod security

        # Revisar si esta incluida la configuracion en el archivo modsec2.user.conf
        if grep -E -i '^include.+?modsec2\.antimalware\.conf' $MODSECCONFDIR/modsec2.user.conf >/dev/null; then
            echo "HTTP Inspector already enabled"
        else
            echo "# Pyxsoft Antimalware" > newfile.txt
            echo "Include $MODSECCONFDIR/modsec2.antimalware.conf" >>newfile.txt
            echo  >>newfile.txt
            cat $MODSECCONFDIR/modsec2.user.conf >> newfile.txt
            mv $MODSECCONFDIR/modsec2.user.conf $MODSECCONFDIR/modsec2.user.conf.bak -f
            mv newfile.txt $MODSECCONFDIR/modsec2.user.conf -f
            chmod 0600 $MODSECCONFDIR/modsec2.user.conf
            chmod 0600 $MODSECCONFDIR/modsec2.antimalware.conf
            echo "HTTP Inspector enabled OK"
        fi

    # Agregar path pyxsoft a CageFS cuando estemos en CloudLinux
    if [ -d /var/cagefs ]; then
        if grep -E -i 'ilabs_antimalware' /etc/cagefs/cagefs.mp >/dev/null; then
            echo "Pyxsoft already installed in CageFS (CloudLinux)"
        else
            echo "# Support for Pyxsoft Anti Malware" >> /etc/cagefs/cagefs.mp
            echo "/usr/share/ilabs_antimalware" >> /etc/cagefs/cagefs.mp
            cagefsctl --remount-all
            echo "Pyxsoft configured for CloudLinud + CageFS"
        fi
    fi

    # Actualizar archivo de confifuracion a JSON
    /usr/local/cpanel/3rdparty/bin/php -q /usr/share/ilabs_antimalware/convertConf.php
   if [ ! -f /usr/share/ilabs_antimalware/config.json ]; then
        cp /usr/share/ilabs_antimalware/config.json.dist /usr/share/ilabs_antimalware/config.json
   fi

	echo "<code>"
        if [ $OS -le 6 ]; then
            /etc/init.d/httpd restart 2>&1
        elif [ $OS -eq 7 ]; then
            systemctl restart httpd 2>&1
        fi
	echo "</code>"
	
	echo 
	echo "*****************************"
	echo " Antimalware plugin upgraded"
	echo "*****************************"
	echo
	
	cat /usr/share/ilabs_antimalware/whatsnew.txt

}

# Reparar permisos
find -type d -exec chmod 755 '{}' \; ; find -type f -exec chmod 644 '{}' \; ;echo "Permissions Fix Done"

# Determinar si gccl esta instalado
if [ ! -e /usr/bin/gcc ]; then
	echo "GCC Compiler is not installed. Please install it and try again"
	exit 1
fi

# Verificar que se ejecuta como root
if [ "$(whoami)" != 'root' ]; then
	echo "Sorry, you need to run this as root"
	exit 1
fi

# Realizar upgrade si corresponde
if [ $CMD = '-u' ]; then
	upgrade_script
	exit 0
fi

# Determinar si clamav esta instalado
if [ ! -e /usr/bin/clamscan ] && [ ! -e /usr/local/cpanel/3rdparty/bin/clamscan ]; then
	echo "ClamAV is not installed. Install it using WHM plugins before installing Pyxsoft Anti Malware"
	exit 1
fi

# Determinar si mod security 2 esta instalado
if [ $EASYAPACHE -eq 4 ]; then
    if ls /etc/apache2/conf.modules.d/*.conf | grep 'mod_security2' > /dev/null; then
        echo "Mod Security 2 installed [OK]"
    else
        echo "Mod Security 2 not installed [ERROR] (EA4)"
        echo "Please install mod security before installing Pyxsoft Anti Malware"
        exit 1
    fi
elif [ $EASYAPACHE -eq 3 ]; then
    if grep -E -i '^include.+?modsec2' /usr/local/apache/conf/httpd.conf >/dev/null; then
        echo "Mod Security 2 installed [OK]"
    else
        echo "Mod Security 2 installed [ERROR] (EA3)"
        echo "Please install mod security before installing Pyxsoft Anti Malware"
        exit 1
    fi

fi

# Determinar si Ioncube esta habilitado en cPanel
ioncube=`/usr/local/cpanel/3rdparty/bin/php -v | grep -i 'ioncube'`
if  [ "$ioncube" != "" ]; then
        echo "Internal Ioncube enabled [OK]"
else
        echo "Internal Ioncube enabled [ERROR]"
		echo "Please enable internal cPanel ioncube loader before installing Pyxsoft Anti Malware"
        exit 1
fi

# Determinar si esta corriendo pure-ftpd
if [ ! -e /var/run/pure-ftpd.pid ]; then
	echo  "Pure FTP is not running in your system."
	echo  "Pure FTP is required."
	exit 1
fi


############################################################################
# Instalar antimalware
############################################################################

# Comprobar que estamos en la carpeta correcta
if [ ! -e modsec_scan.php ]; then
	echo "Wrong folder. Aborting Install."
	exit 1
fi

if [ ! -d $FOLDER ]; then
	mkdir $FOLDER
fi

# Activar programa
H="http://www.pyxsoft.com/gl.php?h=$(hostname)"; wget -q -O - $H > /dev/null

# Copiar todos los archivos a la carpeta de destino
cp * $FOLDER -fR

# Compilar comandos
compileCommands


rm -fR c-elements

# Crear la carpeta reports
mkdir $FOLDER/reports

# Descargar las firmas para usar por primera vez
echo "Downloading signatures (1/3)..."
wget http://labs.pyxsoft.com/sigs/pyx_ask.ndb -q -O /usr/share/ilabs_antimalware/sigs/pyx_ask.ndb
echo "Downloading signatures (2/3)..."
wget http://labs.pyxsoft.com/sigs/pyx.ndb -q -O /usr/share/ilabs_antimalware/sigs/pyx.ndb
echo "Downloading signatures (3/3)..."
wget http://labs.pyxsoft.com/sigs/pyx.hdb -q -O /usr/share/ilabs_antimalware/sigs/pyx.hdb

# Crear el acceso en WHM
cp addon_antimalware.php  /usr/local/cpanel/whostmgr/docroot/cgi/ -f
chmod 0755 /usr/local/cpanel/whostmgr/docroot/cgi/addon_antimalware.php
ln -s /usr/share/ilabs_antimalware /usr/local/cpanel/whostmgr/docroot/cgi/ilabs_antimalware
rm $FOLDER/addon_antimalware.php -f

# Registrar la aplicacion en WHM si no ha sido registrada
/usr/local/cpanel/bin/register_appconfig /usr/share/ilabs_antimalware/includes/pyxsoft_antimalware.conf
if [ ! -f "/var/cpanel/apps/pyxsoft_antimalware.conf" ]; then
	if [ -f "/usr/local/cpanel/bin/register_appconfig" ]; then
		/usr/local/cpanel/bin/register_appconfig /usr/share/ilabs_antimalware/includes/pyxsoft_antimalware.conf
	fi
fi
	

# Establecer permisos para archivos que utilizara mod security
chmod 0755 $FOLDER/modsec_name_scan.php
chmod 0755 $FOLDER/modsec_scan.php
touch $FOLDER/filescan.log
touch $FOLDER/ftp.log
touch $FOLDER/firewall/ipdeny.txt
chmod 0666 $FOLDER/filescan.log
chmod 0666 $FOLDER/license.txt
touch $FOLDER/license2.txt
chmod 0666 $FOLDER/license2.txt
chmod 0666 $FOLDER/firewall/ipdeny.txt
touch $FOLDER/logs/firewall.log
chmod 0666 $FOLDER/logs/firewall.log
touch $FOLDER/firewall/f.dat
chmod 0666 $FOLDER/firewall/f.dat
touch $FOLDER/data/enc_pas.dat
chmod 0666 $FOLDER/data/enc_pas.dat

# -> Escritura de version de modsecurity
touch $FOLDER/logs/modsecversion.txt
chmod 0666 $FOLDER/logs/modsecversion.txt

# -> Chequeo de editor de texto de aplicaciones
chmod 0755 $FOLDER/adicionales/checkApp.php
touch $FOLDER/logs/checkApp.log
chmod 0666 $FOLDER/logs/checkApp.log

# -> Verificar estado de proteccion http
touch $FOLDER/logs/ok.txt
chmod 0666 $FOLDER/logs/ok.txt

# -> Analizar ataques de fuerza bruta
chmod 0755 $FOLDER/adicionales/pyx_bf.php
touch $FOLDER/logs/loginfailed.log
chmod 0666 $FOLDER/logs/loginfailed.log
touch $FOLDER/data/bruteforce.dat
chmod 0666 $FOLDER/data/bruteforce.dat
touch $FOLDER/data/badips.dat
chmod 0666 $FOLDER/data/badips.dat
chmod 0755 $FOLDER/adicionales/bf_test.php

# -> Proteccion contra exploits
 chmod 0755 $FOLDER/adicionales/jce.php

# -> Registro de correos enviados
chmod 0755 $FOLDER/pyx_sendmail.php
touch $FOLDER/logs/mail.log
chmod 0666 $FOLDER/logs/mail.log
touch $FOLDER/data/mailers.dat
chmod 0666 $FOLDER/data/mailers.dat

# -> Registro general
touch $FOLDER/logs/pyxsoft.log
chmod 0666 $FOLDER/logs/pyxsoft.log

# -> Regidtro de proteccion instantanea
touch $FOLDER/logs/instantprotection.log
chmod 0666 $FOLDER/logs/instantprotection.log

# Instalar servicio pyxsoft-antimalware
# \cp -f /usr/share/ilabs_antimalware/system_files/pyxsoft-antimalware /etc/init.d/pyxsoft-antimalware
# chmod 0755 /etc/init.d/pyxsoft-antimalware
# chown root:root /etc/init.d/pyxsoft-antimalware

# Instalar mail watcher para php en futuras versiones
# sed -i 's#^sendmail_path.*#sendmail_path= "/usr/share/ilabs_antimalware/pyx_sendmail.php"#' /usr/local/lib/php.ini

# Establecer permisos de ejecucion a comandos
chmod 0755 $FOLDER/commands/* 
chmod 0755 $FOLDER/pyxsoft-antimalware.pl
chmod 0755 $FOLDER/sendinfo.php
chmod 0744 $FOLDER/sendfile.php

# Crear comandos
if [ ! -f /usr/bin/send2pyxsoft ]; then
    ln -s /usr/share/ilabs_antimalware/sendfile.php /usr/bin/send2pyxsoft
fi

# Actualizar archivo de aviso a usuarios
apacheVersion=$(httpd -v | grep  'Apache/[\d\.]*' --color --max-count=1 -P -o | cut -d/ -f2)
vercomp $apacheVersion 2.4.0
if [ $? -eq 2 ]; then
    # La version de apache es menor a 2.4.0
    echo "Apache version: $apacheVersion (< 2.4.0)"
    mv $FOLDER/amplugin.shtml /usr/local/cpanel/cgi-sys/amplugin.shtml -f
    mv $FOLDER/denied.shtml /usr/local/cpanel/cgi-sys/denied.shtml -f
else
    # La version de apache es mayor o igual a 2.4.0
    echo "Apache version: $apacheVersion (>= 2.4.0)"
    mv $FOLDER/amplugin0204.shtml /usr/local/cpanel/cgi-sys/amplugin.shtml -f
    mv $FOLDER/denied0204.shtml /usr/local/cpanel/cgi-sys/denied.shtml -f
fi

# BF Unlock
mv $FOLDER/cgi-sys/pyx-bf_unlock.php /usr/local/cpanel/cgi-sys/pyx-bf_unlock -f
mv $FOLDER/cgi-sys/tahomabd.ttf /usr/local/cpanel/cgi-sys/tahomabd.ttf -f

# Upload blocked message
chmod 0644 /usr/local/cpanel/cgi-sys/amplugin.shtml
chown root:wheel /usr/local/cpanel/cgi-sys/amplugin.shtml

# Access denied message
chmod 0644 /usr/local/cpanel/cgi-sys/denied.shtml
chown root:wheel /usr/local/cpanel/cgi-sys/denied.shtml

# BF Deny
chmod 0644 /usr/local/cpanel/cgi-sys/bfdenied.shtml
chown root:wheel /usr/local/cpanel/cgi-sys/bfdenied.shtml

# BF Unlock
chmod 0755 /usr/local/cpanel/cgi-sys/pyx-bf_unlock
chown root:wheel /usr/local/cpanel/cgi-sys/pyx-bf_unlock
chmod 0644 /usr/local/cpanel/cgi-sys/tahomabd.ttf
chown root:wheel /usr/local/cpanel/cgi-sys/tahomabd.ttf

# Agregar virtual host para chequeo de configuracion 
\cp -f $FOLDER/pyxsoft-check.conf $POSTVIRTUALHDIR/pyxsoft-check.conf

# Agregar el portfix a archivo de inicio de apache 
reiniciar_apache=false

if [ $OS -le 6 ]; then
    if grep -E -i '^/usr/share/ilabs_antimalware/commands/portfix.sh' /etc/init.d/httpd >/dev/null; then
        echo "Apache port autodetection already installed"
    else
        sed -i "s#^ *case \$ARGV#/usr/share/ilabs_antimalware/commands/portfix.sh\ncase \$ARGV#" /etc/init.d/httpd
        echo "Portfix installed in httpd.ini"
        reiniciar_apache=true
    fi
elif [ $OS -eq 7 ]; then
    :
fi

# Revisar si pyxsoft-check.conf está incluido en post_virtualhost_global 
if grep -E -i '^include.+?pyxsoft-check\.conf' $POSTVIRTUALHDIR/post_virtualhost_global.conf >/dev/null; then
        echo "Pyxsoft Virtual Host already installed"
else
	echo "# Included by Pyxsoft Anti Malware -- Do not delete" > newfile.txt
	echo "Include $POSTVIRTUALHDIR/pyxsoft-check.conf" >> newfile.txt
	echo  >>newfile.txt
	cat $POSTVIRTUALHDIR/post_virtualhost_global.conf >> newfile.txt
	mv $POSTVIRTUALHDIR/post_virtualhost_global.conf $POSTVIRTUALHDIR/post_virtualhost_global.conf.bak -f
	mv newfile.txt $POSTVIRTUALHDIR/post_virtualhost_global.conf -f
	chmod 0600 $POSTVIRTUALHDIR/pyxsoft-check.conf
	chmod 0600 $POSTVIRTUALHDIR/post_virtualhost_global.conf
        reiniciar_apache=true

	echo "Pyxsoft Virtual Host installed"
fi

# Reiniciar Apache
if [ "$reiniciar_apache" = true ] ; then
    echo "Restarting apache..."
    if [ $OS -le 6 ]; then
        /etc/init.d/httpd restart 2>&1
    elif [ $OS -eq 7 ]; then
        systemctl restart httpd 2>&1
    fi
fi

# Agregar inspeccion en mod_security 
echo "Determining the Mod Security installed version..."
echo -n "0" > /usr/share/ilabs_antimalware/logs/modsecversion.txt
wget local.pyxsoft.com?getMS_version -O /dev/null  -q
version=$(</usr/share/ilabs_antimalware/logs/modsecversion.txt)

if [ $version -eq 0 ]; then
	echo "Mod security version could not be detected this time."
	echo "It will be detected when you visit the plugin in WHM"
	\cp -f $FOLDER/modsec2.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf
elif [ "$version" -ge "02090000" ]; then
    echo "Mod security version OK ($version)"
    \cp -f $FOLDER/modsec0290.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf

elif [ "$version" -ge "02070000" ]; then
    echo "Old mod security version: $version. Consider upgrading to 2.9 or superior"
    \cp -f $FOLDER/modsec0270.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf

elif [ "$version" -ge "02060000" ]; then
        echo "You have Mod Security $version. Some features will not work here"
        echo "If possible, upgrade your mod security installation to version 2.7 or superior"
        \cp -f $FOLDER/modsec0260.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf
else
	echo "You have a very old mod security version. Some pyxsoft features will not work here."
	\cp -f $FOLDER/modsec2.antimalware.conf $MODSECCONFDIR/modsec2.antimalware.conf 
fi

chmod 0600 $MODSECCONFDIR/modsec2.antimalware.conf 
rm -f $FOLDER/install.sh

# Instalar FTP inspector
if [ $OS -le 6 ]; then
    chmod 755 $FOLDER/pure-ftpd-inspector.php
    if grep 'pure-ftpd-inspector' /etc/init.d/pure-ftpd >/dev/null; then
    echo "FTP Inspector already installed"
    else
            echo "Installing FTP Inspector in CentOS $OS..."
            # La salida hacia dev null impide que PHP se quede pegado
            sh $FOLDER/includes/install_ftp_inspector.sh >/dev/null
    fi
elif [ $OS -eq 7 ]; then
        echo "We are working to make FTP inspector compatible in CentOS 7.";
fi

# Instalar cron
echo "4 2 * * * root /usr/local/cpanel/3rdparty/bin/php $FOLDER/cron/daily.php" > /etc/cron.d/pyx_antimalware
echo "*/10 * * * * root /usr/local/cpanel/3rdparty/bin/php $FOLDER/cron/cronjobs.php" > /etc/cron.d/pyx_cronjobs

# Agregar path pyxsoft a CageFS cuando estemos en CloudLinux
if [ -d /var/cagefs ]; then
    if grep -E -i 'ilabs_antimalware' /etc/cagefs/cagefs.mp >/dev/null; then
        echo "Pyxsoft already installed in CageFS (CloudLinux)"
    else
        echo "# Support for Pyxsoft Anti Malware" >> /etc/cagefs/cagefs.mp
        echo "/usr/share/ilabs_antimalware" >> /etc/cagefs/cagefs.mp
        cagefsctl --remount-all
        echo "Pyxsoft configured for CloudLinud + CageFS"
    fi
fi

# Revisar si esta incluida la configuracion en el archivo modsec2.user.conf
if grep -E -i '^include.+?modsec2\.antimalware\.conf' $MODSECCONFDIR/modsec2.user.conf >/dev/null; then
        echo "HTTP Inspector already enabled"
else
	echo "# Pyxsoft Antimalware" > newfile.txt
	echo "Include $MODSECCONFDIR/modsec2.antimalware.conf" >>newfile.txt
	echo  >>newfile.txt
	cat $MODSECCONFDIR/modsec2.user.conf >> newfile.txt
	mv $MODSECCONFDIR/modsec2.user.conf $MODSECCONFDIR/modsec2.user.conf.bak -f
	mv newfile.txt $MODSECCONFDIR/modsec2.user.conf -f
	chmod 0600 $MODSECCONFDIR/modsec2.user.conf
	chmod 0600 $MODSECCONFDIR/modsec2.antimalware.conf
	echo "HTTP Inspector enabled OK"

    # Actualizar archivo de confifuracion a JSON
    /usr/local/cpanel/3rdparty/bin/php -q /usr/share/ilabs_antimalware/convertConf.php
    if [ ! -f /usr/share/ilabs_antimalware/config.json ]; then
        cp /usr/share/ilabs_antimalware/config.json.dist /usr/share/ilabs_antimalware/config.json
    fi

	echo "Restarting apache..."
        if [ $OS -le 6 ]; then
            /etc/init.d/httpd restart 2>&1
        elif [ $OS -eq 7 ]; then
            systemctl restart httpd 2>&1
        fi
fi


echo ""
echo ""
echo "****************************************"
echo "* Antimalware Plugin installed"
echo "* Please review configuration in WHM"
echo "****************************************"

