#!/usr/bin/perl
use strict;
use warnings;
use utf8;
 
use AnyEvent;
use Linux::Inotify2;
use File::Find;
use POSIX;
 
my $PID_FILE = "/var/run/pyxsoft-antimalware.pid";
my $hcount=0;

# Fork this process, to run as a daemon
daemonize();
 
# enable autoflush to have faster logging
$|++;
 
# Catch kill signals
local $SIG{TERM} = sub {
    if(-f $PID_FILE){
        unlink($PID_FILE)
    }
 
    print("$0 daemon killed.\n");
    exit 0;
};
local $SIG{INT} = $SIG{TERM};
 
my $cv = AnyEvent->condvar;
# watcher container hash
my %W;
 
# Create Inotify object
my $inotify = Linux::Inotify2->new()
    or die "Failed to created inotify object: $!\n";
 
# Search for directories to watch
find({ wanted => sub { -d $_
                       && create_watcher($inotify, $File::Find::name) } 
     }
    , '/home');
 
# Show directories count
tolog("# of watched directories: $hcount");

# Create event loop poller
my $poller = AnyEvent->io(
        fh   => $inotify->fileno,
        poll => 'r',
        cb   => sub { $inotify->poll }
);
 
# Receive event signals (inotify signals)
$cv->recv;
 
#
# Subroutines
#
sub create_watcher {
    my ($inotify, $dir) = @_;
    if ($dir !~ /^\/home.*?\/.+?\/public_html/ ) {
        # tolog("Not watched: $dir");
        return;
    }

	$hcount++;
	tolog("[$hcount] Watching $dir");				
		
    my $watcher = $inotify->watch($dir, IN_CREATE | IN_CLOSE_WRITE | IN_MOVE | IN_DELETE, sub {
            my $e = shift;
            my $filename  = $e->fullname;
            			
            if(-d $filename && $e->IN_CREATE) {
                create_watcher($inotify, $filename);
				$hcount++;
				tolog("[$hcount] Watching $dir");				
                return
            }
            elsif(-f $filename){
                if($e->IN_CLOSE_WRITE){
                    tolog("IN_CLOSE_WRITE $filename")
                }
				elsif ($e->IN_CREATE) {
					tolog("IN_CREATE $filename")
				}
                elsif($e->IN_MOVED_FROM){
                    tolog("IN_MOVE_FROM $filename")
                }
                elsif($e->IN_MOVED_TO){
                    tolog("IN_MOVED_TO $filename")
                }
                elsif($e->IN_DELETE){
                    tolog("IN_DELETE $filename")
                }
				
            }
    });
    $W{$dir} = $watcher;
}
 
sub daemonize {
# Inspired by http://stackoverflow.com/questions/766397/how-can-i-run-a-perl-script-as-a-system-daemon-in-linux
    POSIX::setsid or die "setsid: $!";
    my $pid = fork ();
    if ($pid < 0) {
        die "fork: $!";
    }
    elsif ($pid) {
        exit 0;
    }
 
    chdir "/";
    umask 0;
    foreach (0 .. (POSIX::sysconf (&POSIX::_SC_OPEN_MAX) || 1024)) {
        POSIX::close $_
    }
 
    open (STDIN, "/dev/null");
    open (STDOUT, ">>/usr/share/ilabs_antimalware/logs/realtime.log");
    open (STDERR, ">&STDOUT");
 
    # Save PID to disk
    open my $pid_file, '>', $PID_FILE
        or die "Could not open PID file: $!\n";
    print { $pid_file } "$$";
    close ($pid_file);
	
	tolog("Pyxsoft Antimalware service started");
} 

sub tolog {
	my $txt=shift;

	# Generar hora actual
	my ($second, $minute, $hour, $dayOfMonth, $month, $yearOffset, $dayOfWeek, $dayOfYear, $daylightSavings) = localtime();
	my $year = 1900 + $yearOffset;
	$month++;
	my $theTime = sprintf("%d-%02d-%02d %02d:%02d:%02d",$year,$month,$dayOfMonth,$hour,$minute,$second); 
	#my $theTime = "$year-$month-$dayOfMonth $hour:$minute:$second";
	print "$theTime $txt\n"; 
}