#!/usr/bin/env bash

# Determinar el canal
if grep  'update_channel.*beta' /usr/share/ilabs_antimalware/config.json >/dev/null; then
    CHANNEL="beta/"
    CHNAME="beta"
else
    CHANNEL=""
    CHNAME="stable"
fi

# Determinar version encoder
if /usr/local/cpanel/3rdparty/bin/php -v | grep 'v10' > /dev/null; then
    ENCODER="-ioncube10"
    ENCODERNAME="ioncube10"
else
    ENCODER=""
    ENCODERNAME="ioncube5"
fi

echo "Upgrading pyxsoft (${CHNAME}/${ENCODERNAME})..."
rm -fR /root/.pyxsoft;
mkdir /root/.pyxsoft

echo "Downloading..."
URL="http://www.pyxsoft.com/software/antimalware/${CHANNEL}anti_malware${ENCODER}.tar.gz"
wget ${URL} -q -O '/root/.pyxsoft/anti_malware.tar.gz' 2>&1

echo "Inflating..."
cd /root/.pyxsoft;
tar -xzf /root/.pyxsoft/anti_malware.tar.gz;

echo "Upgrading...";
cd /root/.pyxsoft/anti_malware;
sh install.sh -u;
cd /root;

# cp /usr/local/cpanel/version