//+------------------------------------------------------------------+
//|                                                  tradeWindow.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#include <stderror.mqh>
#include <stdlib.mqh>

//+------------------------------------------------------------------+
extern int eiStartHH = 10, eiStartMM = 15;
extern int eiEndHH = 10, eiEndMM = 30;


//------------------------------------------------------------------------------
//-
int init()
{
	Comment("");					//start fresh...
	return(ERR_NO_ERROR);
}


//------------------------------------------------------------------------------
//-
int deinit()
{
	Comment("");					//leave no incriminating foot prints!
	return(ERR_NO_ERROR);
}


//------------------------------------------------------------------------------
//-
int start()
{
	static bool sbInSide=false, sbOutSide=false;

	if( !inTradeWindow(eiStartHH,eiEndHH,eiStartMM,eiEndMM) )
	{
		//EA must not trade: is outside trading window
		//-----------------
		if( !sbOutSide )
		{
			//Only print message once at start of: OUTSIDE trading window
			//
			sbOutSide = true;
			sbInSide = false;
			Print("EA not in \'local time\' trade window (",eiStartHH,":",eiStartMM," - ",eiEndHH,":",eiEndMM,")"
						," Local time is ",TimeToStr(TimeLocal(),7));
			Comment("");	//remove comment field as not active
		}	
		return(ERR_NO_ERROR);		//do no work until 'inside' trading window
	}
	
	
	//EA can trade: is inside trading window
	//------------
	if( !sbInSide )
	{
		//Only print message once at start of: INSIDE trading window
		//
		sbInSide = true;
		sbOutSide = false;
		Print("EA in \'local time\' trade window (",eiStartHH,":",eiStartMM," - ",eiEndHH,":",eiEndMM,")"
					," Local time is ",TimeToStr(TimeLocal(),7));
	}	


	//Inside trading window: go about main body of EA code
	//---------------------
	
	//doing some 'visible' work!
	//-
	Comment("\nEA Trading inside \'local time\' trade window (",eiStartHH,":",eiStartMM," - ",eiEndHH,":",eiEndMM,")"
					," Close=",NormalizeDouble(Close[0],Digits));
	
	/*
	...
	THE Holy Grail income making code goes here :o))
	...
	*/
	
	return(ERR_NO_ERROR);

}//start()


//------------------------------------------------------------------------------
//-
bool inTradeWindow ( int iStartHH, int iEndHH, int iStartMM=0, int iEndMM=0 )
{/****************

	COMMENT:
		Is NOW time inside specified start and end time range?
		Minimum actuals are (startHH,endHH)
		
	OUTPUT:
		true = local PC time on or in, start/end time range
		false = local PC time outside, start/end time range
	
	NOTE:
		1.	Default call only needs start,end HH; MM default to zero
				eg, if( inTradeWindow(13,19) )
				returns true if NOW time is anywhere on or between 13:00..19:00 inclusive
		2.	To be more specific supply further resolution MM
				eg, to restrict trading to 13:01..18:59 inclusive then use:
				if( inTradeWindow(13,18,1,59) )
		3.	"LOCAL" computer time:
				Ref:	MQL4 Reference - Date & Time functions - TimeLocal
							Returns local computer time as number of seconds elapsed from 00:00 January 1, 1970.
							At the testing, local time is modelled and is the same as the modelled last known server time.
	*/
	datetime tNow = TimeLocal();
	datetime tNowHH	= TimeHour(tNow);
	datetime tNowMM = TimeMinute(tNow);
	bool bInTrade = false;	//assume outside
	
	if( tNowHH>=iStartHH && tNowHH<=iEndHH )
	{
		if( tNowHH==iStartHH || tNowHH==iEndHH )
		{
			if( tNowMM>=iStartMM && tNowMM<=iEndMM )
			{
				bInTrade = true;
			}
		}
		else bInTrade = true;
	}
	
	return(bInTrade);	
	
}//inTradeWindow()


//------------------------------------------------------------------------------
//-
/* quick test results...
================================


//having 'worked' inside trade window, sees 'outside' so issues message, thereafter waits until 'inside'seen
//
2008.05.02 10:46:10	tradeWindow GBPUSD,M15: EA not in 'local time' trade window (10:30 - 10:45) Local time is 2008.05.02 10:46:10

//having waited, EA sees 'inside'  so issues message, thereafter 'works' by displays Comment(...) on chart
//
2008.05.02 10:30:31	tradeWindow GBPUSD,M15: EA in 'local time' trade window (10:30 - 10:45) Local time is 2008.05.02 10:30:31

//on first time entry code sees that time is 'outside' so issues message, thereafter waits until 'inside' seen
//
2008.05.02 10:26:09	tradeWindow GBPUSD,M15: EA not in 'local time' trade window (10:30 - 10:45) Local time is 2008.05.02 10:26:09

2008.05.02 10:26:07	tradeWindow GBPUSD,M15: initialized
                                            ^^^^^^^^^^^

//EA inputs setup for TradeWindow specified as: 10:30hrs...10:45hrs
//
2008.05.02 10:26:07	tradeWindow GBPUSD,M15 inputs: eiStartHH=10; eiStartMM=30; eiEndHH=10; eiEndMM=45;
                                           ^^^^^^ 

2008.05.02 10:25:46	tradeWindow GBPUSD,M15: loaded successfully
                                            ^^^^^^^^^^^^^^^^^^^
*/

