//+------------------------------------------------------------------+
//| ADX Crossing.mq4                                                 +
//| Author: Amir                                                     +
//| 20070623 - Modified by HerbertH (Add MPower rules filter, Alerts)+
//+------------------------------------------------------------------+
#property  copyright "Author - Amir"

#property indicator_chart_window
#property indicator_buffers      2
#property indicator_width1       2
#property indicator_width2       2
#property indicator_color1       Blue
#property indicator_color2       Red

extern int     ADXbars           =  14;
extern int     MaxBars           =  1000;
extern bool    MPowerCrossOnly   =  true;
extern bool    UseAlert          =  false;

double   val1[],
         val2[],
         b4plusdi,
         nowplusdi,
         b4minusdi,
         nowminusdi,
         ADX_0,
         ADX_1;
bool     CrossUp,
         CrossDown;
string   AlertTXT;
datetime AlertBar,
         LastAlertBar;


int init()
{
   string short_name;
   IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,233);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,234);
   SetIndexBuffer(0,val1);
   SetIndexBuffer(1,val2);
   return(0);
}


int start()
{   
   if (MaxBars>=Bars) MaxBars=Bars;
   SetIndexDrawBegin(0,Bars-MaxBars);
   SetIndexDrawBegin(1,Bars-MaxBars);
   int i,shift,counted_bars=IndicatorCounted();

   if(counted_bars<0) return(-1);

   if(counted_bars<1)
   {
      for(i=1;i<=MaxBars;i++) val1[MaxBars-i]=0.0;
      for(i=1;i<=MaxBars;i++) val2[MaxBars-i]=0.0;
   } 

   CrossDown = false;
   CrossUp   = false;

   for (shift = MaxBars; shift>=0; shift--) 
   {
      b4plusdi    = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_PLUSDI,shift+1);
      nowplusdi   = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_PLUSDI,shift);
      b4minusdi   = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_MINUSDI,shift+1);
      nowminusdi  = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_MINUSDI,shift);
      ADX_1       = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_MAIN,shift+1);
      ADX_0       = iADX(NULL,0,ADXbars,PRICE_CLOSE,MODE_MAIN,shift);

      if(b4plusdi>b4minusdi && nowplusdi<nowminusdi)  // Cross down found, check validity
      {
         CrossUp   = false;
         CrossDown = CrossDown || (b4plusdi<20 && b4minusdi<20 && ADX_1>20);
      }
      if(b4plusdi<b4minusdi && nowplusdi>nowminusdi)  // Cross up found, check validity
      {
         CrossDown = false;
         CrossUp   = CrossUp || (b4plusdi<20 && b4minusdi<20 && ADX_1>20);
      }

      if ((!MPowerCrossOnly && b4plusdi<b4minusdi && nowplusdi>nowminusdi) ||
                     (MPowerCrossOnly && CrossUp && nowplusdi>20 && ADX_0>20))
      {
         val1[shift] = Low[shift]-10*Point;
         CrossUp     = false;
         AlertTXT    = " - MPower ADX Cross UP";
         AlertBar    = Time[0];
      }
      if ((!MPowerCrossOnly && b4plusdi>b4minusdi && nowplusdi<nowminusdi) ||
                     (MPowerCrossOnly && CrossDown && nowminusdi>20 && ADX_0>20))
      {
         val2[shift] = High[shift]+10*Point;
         CrossDown   = false;
         AlertTXT    = " - MPower ADX Cross DOWN";
         AlertBar    = Time[0];
      }
   }

   if(UseAlert && LastAlertBar!=AlertBar)
   {
      Alert(Symbol(), ",", Period(), AlertTXT);
      LastAlertBar=AlertBar;
   }

   return(0);
}